;  speedy.inc - speedy 1050 memory locations
;
;  Copyright (c) 2014 by Matthias Reichl <hias@horus.com>
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;

; ZP RAM locations

SDBYTE	= $00	; byte to transmit for SDIND

COMST	= $11	; communication status (0=ok)
COMST_OK	= $00
COMST_IOERR	= $40
COMST_CMDERR	= $80

IND	= $19	; vector to data buffer
CHKSUM	= $1B	; data block checksum

BLOCKS	= $62	; number of blocks to transfer
SDIND	= $6A	; vector to send byte code

DAUX1	= $82
DAUX2	= $83

; rom code entry points
BEREIT	= $FF06
SEND41	= $FF57		; send ack
SEND43	= $FF5A		; send complete
SEND45	= $FF5D		; send error
SEND4E	= $FF60		; send nak

;SP_HEXOUT	= $FFA5		; show A in hex on display
RD256	= $FF36		; receive 256 bytes to EXTBUF
SD256B	= $FF51		; send 256 bytes from EXTBUF, including checksum
SDBTS	= $FF54		; send A bytes from X/Y
QUITT	= $FF7B		; send complete (COMST bit7=0) or error

TSTDEN	= $FFBD		; check density

SENDEN	= $FFCF		; send X/Y bytes from (IND) without checksum

; only available in version 1.5!
INSTALL	= $FFD2		; install command (X/Y points to 3-bytes address)

VERSION	= $FFFB		; version byte

; ram locations
EXTBUF	= $9E00
CMTBL	= $9F00

; hw locations

DISP_LO	= $4000
DISP_HI	= $4001
DISP_DN	= $4002
BUZZER	= $4003

RAMBANK = $6000
ROMBANK	= $7000

; default rom bank 2, ignore bits 2-5
DEFAULT_ROMBANK	= $82

; mode select: rom base 4k bank
CFG_ROM_BASE	= $7010
; floppy mode
CFG_MODE	= $7011

	.include "speedymodes.inc"

; I2C addresses
I2C_D0_C0	= $7020
I2C_D0_C1	= $7021
I2C_D1_C0	= $7022
I2C_D1_C1	= $7023
I2C_D_IN	= I2C_D0_C0

I2C_EEPROM_ADR	= $A0

; config inputs:
; bit 4-0: SW2 ENC_B ENC_A OK SW1
CFG_MODE_IN	= $7018

NUM_INPUTS	= 5
OFS_ENC_A       = 0
OFS_ENC_B       = 1
OFS_SW1         = 3
OFS_OK          = 2
OFS_SW2         = 4

; use SW1+SW2 to select between 4 configs
NUMCFGS		= 4

; config led:
; bit 0=1 turns config LED on
CFG_LED		= $7019

XRAM_BASE	= $A000
FLASH_BASE	= $C000

; super speedy supports 192k RAM, mega speedy 256k so we have
; 64k free RAM for the flash buffer
RAM_BUFFER_PAGE	= $300
; the same as 4k block number
RAM_BUFFER_BLOCK = [RAM_BUFFER_PAGE/16]

; user vectors
RAMVEC	= $90
FLASHVEC	= $92
TMPVEC	= $94
