;  speedy-flash.inc - fixed locations for flasher
;
;  Copyright (C) 2014 Matthias Reichl <hias@horus.com>
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; locations in speedy ROM
SR_ENTRY_BASE		= $C100

SR_ENTRY_SIZE		= 3
XMIT_CONFIG_CODE	= SR_ENTRY_BASE+[SR_ENTRY_SIZE*0]
XMIT_HISIO_CODE		= SR_ENTRY_BASE+[SR_ENTRY_SIZE*1]
XMIT_MYDOS_BOOT_CODE	= SR_ENTRY_BASE+[SR_ENTRY_SIZE*2]
XMIT_MYDOS_DOSSYS_CODE	= SR_ENTRY_BASE+[SR_ENTRY_SIZE*3]
XMIT_FLASHER_CODE	= SR_ENTRY_BASE+[SR_ENTRY_SIZE*4]
XMIT_MYPDOS_CODE	= SR_ENTRY_BASE+[SR_ENTRY_SIZE*5]
SET_CONFIG		= SR_ENTRY_BASE+[SR_ENTRY_SIZE*6]
READ_EE_CONFIG		= SR_ENTRY_BASE+[SR_ENTRY_SIZE*7]
WRITE_EE_CONFIG		= SR_ENTRY_BASE+[SR_ENTRY_SIZE*8]

; start of code/data area in main-banks
DATA_START_MAIN		= $C300

; start of code/data area in non-main-banks
DATA_START		= $C100

; Atari memory locations

; load addresses
MYDOS_BOOT_ADR		= $0700
MYDOS_DOSSYS_ADR	= $0B0A

; MyDOS 4.53/4 dosini and dosvec
MYDOS_DOSINI		= $07E0
MYDOS_DOSVEC		= $1B47

MYDOS_SIO1		= $07AC
MYDOS_SIO2		= $0B35
MYDOS_SIO3		= $0B97

MYDOS_DOSVEC_HI		= $1A7A
MYDOS_DOSVEC_LO		= $1A7E

MYPDOS_ADR		= $1000
SOFTCONFIG_ADR		= $2000

; temp (speedy) highspeed SIO for booting
HISIO_BOOT_ADR		= $3800
