#!/bin/bash
set -e
if [ $# -ne 1 ] ; then
	echo "usage: $0 out.rom"
	exit 1
fi
OUT="$1"
SINGLE_DIR=../roms

dd if=/dev/zero bs=1024 count=512 | tr '\000' '\377' > $OUT

# parameters: 4k-block filename
add() {
	if [[ "$2" == */* ]] ; then
		FILE="$2"
	else
		FILE="${SINGLE_DIR}/$2"
	fi
	dd if="$FILE" of="$OUT" bs=4096 conv=notrunc seek="$1"
}

# speedy slots, 16k
add 0 speedy-bibodos.rom
add 4 speedy-hss.rom
add 8 speedy-floppy2000.rom
add 12 speedy-bibodos.rom

# super speedy slots, 16k
add 16 speedy-supercopy.rom
add 20 speedy-supercopy.rom
add 24 speedy-supercopy.rom
add 28 speedy-supercopy.rom

# turbo slots, 8k
add 32 turbo1050-35.rom
add 34 turbo1050-34.rom
add 36 turbo1050-35.rom
add 38 turbo1050-35.rom

# happy slots, 8k
#add 40 happy-orig-happywar.rom
#add 42 happy-disp-dietrich.rom
#add 44 happy-disp-warpguus.rom
#add 46 happy-orig-happywar.rom

# original 1050, 4k
add 48 1050-revL.rom
add 49 1050-revK.rom
add 50 1050-revJ.rom
add 51 1050-revL.rom

# US Doubler, 4k
#add 52 usdblr.rom
#add 53 usdblr.rom
#add 54 usdblr.rom
#add 55 usdblr.rom

# SuperMax, 4k
#add 56 supermax-fast.rom
#add 57 supermax-slow.rom
#add 58 supermax-fast.rom
#add 59 supermax-slow.rom

# Super Archiver, 4k
#add 60 archiver-nir.rom
#add 61 archiver-larry.rom
#add 62 archiver-nir.rom
#add 63 archiver-nir.rom

# Mega Speedy, 32k
add 64 ./flasher.rom
add 72 ./flasher.rom
add 80 ./flasher.rom
add 88 ./flasher.rom

# 1050 Duplicator, 8k
add 96 duplicator-300.rom
add 98 duplicator-310.rom
add 100 duplicator-300.rom
add 102 duplicator-300.rom
# TOMS Multi, 8k in slots 3-4
#add 100 toms.rom
#add 102 toms.rom

# 32k flash slot
add 112 ./flasher.rom

# 32k config slot
add 120 ./config.rom
