;  speedycmd.inc - new speedy command definitions
;
;  Copyright (c) 2014 by Matthias Reichl <hias@horus.com>
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;

; read 256 bytes of extended ram
; DAUX contains page number (0-1023)
CMD_READ_XRAM	= $70

; write 256 bytes of extended ram
; DAUX contains page number (0-1023)
CMD_WRITE_XRAM	= $71

; read 256 bytes of flash
; DAUX contains page number (0-2047)
CMD_READ_FLASH	= $72

; program flash with XRAM contents at $30000
; DAUX1 = starting 4k flash block number (0-127)
; DAUX2 = number of 4k blocks (1-16)
;
; returns 1 status byte:
; 0 = OK
; $43 ("C") = invalid block count
; $45 ("E") = error erasing flash
; $50 ("P") = error programming flash
; $56 ("V") = error verifying flash
CMD_FLASH_4K	= $73

; start config
; DAUX1 = 4k block number
; DAUX2 = mode
CMD_START_CONFIG	= $74

; read config
; returns 2 bytes:
; byte 1 = current 4k block number
; byte 2 = mode
CMD_READ_CONFIG		= $75
